#!/bin/bash
#
#Beschreibung: schaltet den Drucker an und nach dem Ausdruck wieder aus
#
#benötigt: /usr/bin/sispmctl
#
#Aufruf: printeron.sh
#
#Hinweise und Fehler an tuxator@tuxator.de
#
#Status: ok
###################################################################
#Variablen
retval=0
plugnumber=1		#Nummer der zu schaltenden Dose
#Prüfe auf Voraussetzungen
if [[ ! -e /usr/bin/sispmctl ]]; then 
	retval=1
fi
#lese Staustus des Druckers aus
status=$(sispmctl -qg ${plugnumber})
if [[ ${status} == "on" ]]; then
	retval=2
fi
if [[ ${retval} == 0 ]]; then
        sispmctl -qo ${plugnumber}
	retval=${?}
	if [[ ${retval} == 0 ]]; then
		#warte bis Drucker fertig
		while [[ $(ls --ignore=tmp /var/spool/cups/) ]]
		do
			sleep 1
		done
		#warte auf Restarbeiten
		sleep 40
                #schalte Drucker aus
		sispmctl -qf ${plugnumber}
		retval=${?}
	fi
fi
exit ${retval}
