#!/bin/bash
#
#Beschreibung: löst auf Tastendruck am Scanner entsprechende Aktion aus
#
#benötigt: /usr/bin/ck-list-sessions /usr/bin/scanimage /usr/bin/convert /usr/bin/tiff2ps /usr/bin/steghide
#                                                                        (libtifftools) 
#Aufruf: buttonpressed.sh Tastennummer Backend
#
#Hinweise und Fehler an tuxator@tuxator.de
#
#Status: ok
#####################################################################################################################
PATH=/bin:/usr/bin                                                                                                  #
tmptif="/tmp/scan.tiff"                                                                                             #
tmpjpg="/tmp/scan.jpg"                                                                                              #
lockfile="/tmp/scan.lock"                                                                                           #
scanfile="scanfile.tiff"                                                                                            #
path=$(dirname ${scanfile})                                                                                         #
stegfile=".steghide/copyright.txt"		#Copyright für Bilder                                                       #
passfile=".steghide/passphrase.txt"		#Passphrase für Steghide                                                    #
typeset -i counter                                                                                                  #
typeset -i oldcounter                                                                                               #
typeset -i item=0                                                                                                   #
typeset -i retval=0                                                                                                 #
#####################################################################################################################
#Prüfung auf Voraussetzungen                                                                                        #
for cmd in /usr/bin/ck-list-sessions /usr/bin/scanimage /usr/bin/convert /usr/bin/tiff2ps                           #
do                                                                                                                  #
	if [[ ! -e ${cmd} ]]; then                                                                                      #
		echo "${cmd} nicht gefunden"                                                                                #
		retval=1                                                                                                    #
	fi                                                                                                              #
done                                                                                                                #
#####################################################################################################################
#Prüfe Argumente                                                                                                    #
if [[ ! ${1} ]] || [[ ! ${2} ]]; then                                                                               #
	echo "fehlende Argumente"                                                                                       #
	retval=2                                                                                                        #
fi                                                                                                                  #
#####################################################################################################################
#welcher User benutzt Scanner?                                                                                      #
#####################################################################################################################
#prüfe, welches x-display auf aktiv gesetzt ist                                                                     #
displayarray=($(ck-list-sessions | grep -e "active\|x11-display " | sed 's/ //g'))                                  #
#bestimme Display und zugehörigen User                                                                              #
#Durchlaufe Array bis Ende der Werte                                                                                #
while [[ ${displayarray[${item}]} != "" ]]                                                                          #
do                                                                                                                  #
	isactive=$(echo ${displayarray[${item}]} | sed 's/active=//g')                                                  #
	if [[ ${isactive} == "TRUE" ]]; then                                                                            #
		#Screen-Nummer                                                                                              #
		whatscreen=$(echo ${displayarray[${item}+1]} | sed -e 's/x11-display=//g' -e "s/'//g")                      #
		#zugehöriger User                                                                                           #
		whatsmyname=($(who | grep -E "${whatscreen}" | awk '{print $1}'))                                           #
		fi                                                                                                          #
	#Screen nicht aktiv -> 2 Werte weiter                                                                           #
	item=${item}+2                                                                                                  #
done                                                                                                                #
#####################################################################################################################
#Niemand am X-Server angemeldet, trotzdem kopieren (Taste 2) zulassen                                               #
if [[ ${whatsmyname} == "" ]] && [[ ${1} != "2" ]]; then                                                            #
	echo "kein User am X-Server angemeldet"                                                                         #
	retval=3                                                                                                        #
fi                                                                                                                  #
#####################################################################################################################
#Wenn alle Voraussetzungen ok und User an X angemeldet -> reagiere auf Tasten                                       #
if (( ${retval} == 0 )) && [[ ! -f ${lockfile} ]]; then                                                             #
	touch ${lockfile}                                                                                               #
	homedir=$(echo "/home/${whatsmyname}/")                                                                         #
#####################################################################################################################
#####################################################################################################################
#Tasten                                                                                                             #
#####################################################################################################################
	case ${1} in                                                                                                    #
	1)                                                                                                              #
		#Scan                                                                                                       #
		cd ${homedir}                                                                                               #
		#############################################################################################################
		# Prüfe, ob Scanfile schon existiert                                                                        #
		#############################################################################################################
		counter=1                                                                                                   #
		if [[ -f ${scanfile} ]]; then                                                                               #
			while [[ -e "${path}/${scanfile}" ]]                                                                    #
			do                                                                                                      #
				fext=$(echo ${scanfile##*.})                                                                        #
				fname=$(echo ${scanfile%%.*})                                                                       #
				if (( ${counter} > 1 )); then                                                                       #
					oldcounter=${counter}-1                                                                         #
					scanfile=$(echo "${scanfile}" | sed "s/#${oldcounter}/#${counter}/g")                           #
				else                                                                                                #
					if [[ ${fname} == ${fext} ]]; then                                                              #
						scanfile=$(echo "${scanfile}#${counter}")                                                   #
					else                                                                                            #
						scanfile=$(echo "${fname}#${counter}.${fext}")                                              #
					fi                                                                                              #
				fi                                                                                                  #
				counter=${counter}+1                                                                                #
			done                                                                                                    #
			scanfile=$(echo "${path}/${scanfile}")                                                                  #
		fi                                                                                                          #
		#############################################################################################################
		#Scanne ins Tiff-Format von Gerät $2 in Farbe, Auflösung 600 dpi, Helligkeit -30, Format A4                 #
		scanimage --format=tiff -d ${2} --mode=Color --resolution=600 --brightness=-30 -x 210 -y 295 > ${scanfile}  #
		retval=${?}                                                                                                 #
		#Besitzer der eingescannten Datei ändern                                                                    #
		chown ${whatsmyname}:${whatsmyname} ${scanfile}                                                             #
		#wenn gdm3 läuft - keine Anzeige möglich -> Abbruch                                                         #
		if [[ $(pidof gdm3) ]]; then                                                                                   #
			echo "Mit gdm3 ist keine Anzeige möglich. Nutze bitte einen alternativen Desktop-Manager"               #
			echo "Der Scan liegt in Deinem Home-Verzeichnis als ${scanfile}"                                        #
			retval=4                                                                                                #
		else                                                                                                        #
			#Anzeigen mit Bildbetrachter auf Display des Users                                                      #
			#Kview                                                                                                  #
			#su ${whatsmyname} -c "env DISPLAY=${whatscreen} kview ${scanfile} &"                                   #
			#gpicview                                                                                               #
			su ${whatsmyname} -c "env DISPLAY=${whatscreen} gpicview ${scanfile}&"                                  #
			retval=${retval}+${?}                                                                                   #
		fi                                                                                                          #
		;;                                                                                                          #
#####################################################################################################################
	2)                                                                                                              #
		#Copy                                                                                                       #
		#Scanne ins Tiff-Format von Gerät $2 in Graustufen, Auflösung 300 dpi, Helligkeit -3, Format A4             #
		scanimage --format=tiff -d ${2} --mode=Gray --resolution=300 --brightness=-3 -x 210 -y 295 > ${tmptif}      #
		retval=${?}                                                                                                 #
		#in Postscript wandeln A4-Format (w/h in inches) und drucken                                                #
		tiff2ps -z -w 8.27 -h 11.69 ${tmptif} | lp                                                                  #
		retval=${retval}+${?}                                                                                       #
		;;                                                                                                          #
#####################################################################################################################
	3)                                                                                                              #
		#Mail                                                                                                       #
		#Scanne ins Tiff-Format von Gerät $2 in Farbe, Auflösung 600 dpi, Helligkeit -30, Format A4                 #
		scanimage --format=tiff -d ${2} --mode=Color --resolution=600 --brightness=-30 -x 210 -y 295 > ${tmptif}    #
		retval=${?}                                                                                                 #
		#nach jpg wandeln und auf max 1024 verkleinern                                                              #
		convert -filter Cubic -resize 1024x1024 ${tmptif} ${tmpjpg}                                                 #
		retval=${retval}+${?}                                                                                       #
		cd ${homedir}                                                                                               #
		#####################################################################################                       #
		#Mit Hilfe von steghide Copyright setzen                                            #                       #
		#####################################################################################                       #
		if [[ -f ${stegfile} ]] && [[ -f ${passfile} ]] && [[ -e /usr/bin/steghide ]]; then #                       #
			passphrase=$(grep passphrase ${passfile} | awk '{print $2}')                    #                       #
			steghide embed -cf ${tmpjpg} -ef ${stegfile} -p ${passphrase} -q                #                       #
			retval=${retval}+${?}                                                           #                       #
		fi                                                                                  #                       #
		#####################################################################################                       #
		#wenn gdm3 läuft - keine Anzeige möglich -> Abbruch                                                         #
		if [[ $(pidof gdm3) ]]; then                                                                                #
			echo "Mit gdm3 ist keine Anzeige möglich. Nutze bitte einen alternativen Desktop-Manager"               #
			echo "Der Scan liegt unter ${tmpjpg}"                                                                   #
			retval=4                                                                                                #
		else                                                                                                        #
			#als Mailanhang senden                                                                                  #
			#Kmail                                                                                                  #
			#su ${whatsmyname} -c "env DISPLAY=${whatscreen} kmail --composer --attach file:${tmpjpg} &"            #
			#Claws-mail                                                                                             #
			su ${whatsmyname} -c "env DISPLAY=${whatscreen} claws-mail --compose --attach ${tmpjpg} &"              #
			retval=${retval}+${?}                                                                                   #
		fi                                                                                                          #
		;;                                                                                                          #
	esac                                                                                                            #
rm ${lockfile}                                                                                                      #
#####################################################################################################################
else                                                                                                                #
	if (( ${retval} == 0 )); then                                                                                   #
		echo "Scanner beschäftigt ${2}"                                                                             #
		retval=5                                                                                                    #
	fi                                                                                                              #
fi                                                                                                                  #
exit ${retval}                                                                                                      #
#####################################################################################################################
